/*
 * linux/include/asm-arm/arch-s3c2440/time.h
 */

#ifndef __ASM_ARCH_TIME_H
#define __ASM_ARCH_TIME_H

#include <asm/arch/hardware.h>
#include <asm/arch/irqs.h>

/* kernel timer uses Timer #4 on S3C2440 */
#define	TCON_AUTO		(1<<22)
#define	TCON_MANUAL		(1<<21)
#define	TCON_START		(1<<20)

static void timer_interrupt(int irq, void *dev_id, struct pt_regs *regs)
{
	do_timer(regs);
}

extern void printascii(char *);

extern __inline__ void setup_timer(void)
{
	IO_TCFG0  = (PRESCALER << 8);
	IO_TCFG1  = 0;	/* DIVIVER = 2 */
	IO_TCNTB4 = (CLOCK_TICK_RATE/HZ);
	IO_TCON   = (TCON_AUTO | TCON_MANUAL);
	timer_irq.handler = timer_interrupt;
	setup_arm_irq(IRQ_TIMER4, &timer_irq);
	IO_TCON   = (TCON_AUTO | TCON_START);
}

#endif /* __ASM_ARCH_TIME_H */
