/*
 * linux/include/asm-arm/arch-s3c2440/s3c2440.h
 */

#ifndef __ASM_ARCH_S3C2440_H
#define __ASM_ARCH_S3C2440_H

/* Memory Controller */
#define IO_BWSCON		(*(volatile unsigned long *)(IO_BASE+0x00000000))
#define IO_BANKCON0		(*(volatile unsigned long *)(IO_BASE+0x00000004))
#define IO_BANKCON1		(*(volatile unsigned long *)(IO_BASE+0x00000008))
#define IO_BANKCON2		(*(volatile unsigned long *)(IO_BASE+0x0000000c))
#define IO_BANKCON3		(*(volatile unsigned long *)(IO_BASE+0x00000010))
#define IO_BANKCON4		(*(volatile unsigned long *)(IO_BASE+0x00000014))
#define IO_BANKCON5		(*(volatile unsigned long *)(IO_BASE+0x00000018))
#define IO_BANKCON6		(*(volatile unsigned long *)(IO_BASE+0x0000001c))
#define IO_BANKCON7		(*(volatile unsigned long *)(IO_BASE+0x00000020))
#define IO_REFRESH		(*(volatile unsigned long *)(IO_BASE+0x00000024))
#define IO_BANKSIZE		(*(volatile unsigned long *)(IO_BASE+0x00000028))
#define IO_MRSRB6		(*(volatile unsigned long *)(IO_BASE+0x0000002c))
#define IO_MRSRB7		(*(volatile unsigned long *)(IO_BASE+0x00000030))

/* USB Host Controller */
#define IO_HcRevision		(*(volatile unsigned long *)(IO_BASE+0x01000000))
#define IO_HcControl		(*(volatile unsigned long *)(IO_BASE+0x01000004))
#define IO_HcCommonStatus	(*(volatile unsigned long *)(IO_BASE+0x01000008))
#define IO_HcInterruptStatus	(*(volatile unsigned long *)(IO_BASE+0x0100000c))
#define IO_HcInterruptEnable	(*(volatile unsigned long *)(IO_BASE+0x01000010))
#define IO_HcInterruptDisable	(*(volatile unsigned long *)(IO_BASE+0x01000014))
#define IO_HcHCCA		(*(volatile unsigned long *)(IO_BASE+0x01000018))
#define IO_HcPeriodCuttentED	(*(volatile unsigned long *)(IO_BASE+0x0100001c))
#define IO_HcControlHeadED	(*(volatile unsigned long *)(IO_BASE+0x01000020))
#define IO_HcControlCurrentED	(*(volatile unsigned long *)(IO_BASE+0x01000024))
#define IO_HcBulkHeadED		(*(volatile unsigned long *)(IO_BASE+0x01000028))
#define IO_HcBulkCurrentED	(*(volatile unsigned long *)(IO_BASE+0x0100002c))
#define IO_HcDoneHead		(*(volatile unsigned long *)(IO_BASE+0x01000030))
#define IO_HcRmInterval		(*(volatile unsigned long *)(IO_BASE+0x01000034))
#define IO_HcFmRemaining	(*(volatile unsigned long *)(IO_BASE+0x01000038))
#define IO_HcFmNumber		(*(volatile unsigned long *)(IO_BASE+0x0100003c))
#define IO_HcPeriodicStart	(*(volatile unsigned long *)(IO_BASE+0x01000040))
#define IO_HcLSThreshold	(*(volatile unsigned long *)(IO_BASE+0x01000044))
#define IO_HcRhDescriptorA	(*(volatile unsigned long *)(IO_BASE+0x01000048))
#define IO_HcRhDescriptorB	(*(volatile unsigned long *)(IO_BASE+0x0100004c))
#define IO_HcRhStatus		(*(volatile unsigned long *)(IO_BASE+0x01000050))
#define IO_HcRhPortStatus1	(*(volatile unsigned long *)(IO_BASE+0x01000054))
#define IO_HcRhPortStatus2	(*(volatile unsigned long *)(IO_BASE+0x01000058))

/* Interrupt Controller */
#define	INT_CTRL_BASE		(IO_BASE+0x02000000) /* for entry-armv.S */
#define IO_SRCPND		(*(volatile unsigned long *)(IO_BASE+0x02000000))
#define IO_INTMOD		(*(volatile unsigned long *)(IO_BASE+0x02000004))
#define IO_INTMSK		(*(volatile unsigned long *)(IO_BASE+0x02000008))
#define IO_PRIORITY		(*(volatile unsigned long *)(IO_BASE+0x0200000c))
#define IO_INTPND		(*(volatile unsigned long *)(IO_BASE+0x02000010))
#define IO_INTOFFSET		(*(volatile unsigned long *)(IO_BASE+0x02000014))
#define IO_SUBSRCPND		(*(volatile unsigned long *)(IO_BASE+0x02000018))
#define IO_INTSUBMSK		(*(volatile unsigned long *)(IO_BASE+0x0200001c))

/* DMA */
#define IO_DISRC0		(*(volatile unsigned long *)(IO_BASE+0x03000000))
#define IO_DISRCC0		(*(volatile unsigned long *)(IO_BASE+0x03000004))
#define IO_DIDST0		(*(volatile unsigned long *)(IO_BASE+0x03000008))
#define IO_DIDSTC0		(*(volatile unsigned long *)(IO_BASE+0x0300000c))
#define IO_DCON0		(*(volatile unsigned long *)(IO_BASE+0x03000010))
#define IO_DSTAT0		(*(volatile unsigned long *)(IO_BASE+0x03000014))
#define IO_DCSRC0		(*(volatile unsigned long *)(IO_BASE+0x03000018))
#define IO_DCDST0		(*(volatile unsigned long *)(IO_BASE+0x0300001c))
#define IO_DMASKTRIG0		(*(volatile unsigned long *)(IO_BASE+0x03000020))
#define IO_DISRC1		(*(volatile unsigned long *)(IO_BASE+0x03000040))
#define IO_DISRCC1		(*(volatile unsigned long *)(IO_BASE+0x03000044))
#define IO_DIDST1		(*(volatile unsigned long *)(IO_BASE+0x03000048))
#define IO_DIDSTC1		(*(volatile unsigned long *)(IO_BASE+0x0300004c))
#define IO_DCON1		(*(volatile unsigned long *)(IO_BASE+0x03000050))
#define IO_DSTAT1		(*(volatile unsigned long *)(IO_BASE+0x03000054))
#define IO_DCSRC1		(*(volatile unsigned long *)(IO_BASE+0x03000058))
#define IO_DCDST1		(*(volatile unsigned long *)(IO_BASE+0x0300005c))
#define IO_DMASKTRIG1		(*(volatile unsigned long *)(IO_BASE+0x03000060))
#define IO_DISRC2		(*(volatile unsigned long *)(IO_BASE+0x03000080))
#define IO_DISRCC2		(*(volatile unsigned long *)(IO_BASE+0x03000084))
#define IO_DIDST2		(*(volatile unsigned long *)(IO_BASE+0x03000088))
#define IO_DIDSTC2		(*(volatile unsigned long *)(IO_BASE+0x0300008c))
#define IO_DCON2		(*(volatile unsigned long *)(IO_BASE+0x03000090))
#define IO_DSTAT2		(*(volatile unsigned long *)(IO_BASE+0x03000094))
#define IO_DCSRC2		(*(volatile unsigned long *)(IO_BASE+0x03000098))
#define IO_DCDST2		(*(volatile unsigned long *)(IO_BASE+0x0300009c))
#define IO_DMASKTRIG2		(*(volatile unsigned long *)(IO_BASE+0x030000a0))
#define IO_DISRC3		(*(volatile unsigned long *)(IO_BASE+0x030000c0))
#define IO_DISRCC3		(*(volatile unsigned long *)(IO_BASE+0x030000c4))
#define IO_DIDST3		(*(volatile unsigned long *)(IO_BASE+0x030000c8))
#define IO_DIDSTC3		(*(volatile unsigned long *)(IO_BASE+0x030000cc))
#define IO_DCON3		(*(volatile unsigned long *)(IO_BASE+0x030000d0))
#define IO_DSTAT3		(*(volatile unsigned long *)(IO_BASE+0x030000d4))
#define IO_DCSRC3		(*(volatile unsigned long *)(IO_BASE+0x030000d8))
#define IO_DCDST3		(*(volatile unsigned long *)(IO_BASE+0x030000dc))
#define IO_DMASKTRIG3		(*(volatile unsigned long *)(IO_BASE+0x030000e0))

/* Clock & Power Management */
#define IO_LOCKTIME		(*(volatile unsigned long *)(IO_BASE+0x04000000))
#define IO_MPLLCON		(*(volatile unsigned long *)(IO_BASE+0x04000004))
#define IO_UPLLCON		(*(volatile unsigned long *)(IO_BASE+0x04000008))
#define IO_CLKCON		(*(volatile unsigned long *)(IO_BASE+0x0400000c))
#define IO_CLKSLOW		(*(volatile unsigned long *)(IO_BASE+0x04000010))
#define IO_CLKDIVN		(*(volatile unsigned long *)(IO_BASE+0x04000014))
#define IO_CAMDIVN		(*(volatile unsigned long *)(IO_BASE+0x04000018))

/* LCD Controller */
#define IO_LCDCON1		(*(volatile unsigned long *)(IO_BASE+0x05000000))
#define IO_LCDCON2		(*(volatile unsigned long *)(IO_BASE+0x05000004))
#define IO_LCDCON3		(*(volatile unsigned long *)(IO_BASE+0x05000008))
#define IO_LCDCON4		(*(volatile unsigned long *)(IO_BASE+0x0500000c))
#define IO_LCDCON5		(*(volatile unsigned long *)(IO_BASE+0x05000010))
#define IO_LCDSADDR1		(*(volatile unsigned long *)(IO_BASE+0x05000014))
#define IO_LCDSADDR2		(*(volatile unsigned long *)(IO_BASE+0x05000018))
#define IO_LCDSADDR3		(*(volatile unsigned long *)(IO_BASE+0x0500001c))
#define IO_REDLUT		(*(volatile unsigned long *)(IO_BASE+0x05000020))
#define IO_GREENLUT		(*(volatile unsigned long *)(IO_BASE+0x05000024))
#define IO_BLUELUT		(*(volatile unsigned long *)(IO_BASE+0x05000028))
#define IO_DITHMODE		(*(volatile unsigned long *)(IO_BASE+0x0500004c))
#define IO_TPAL			(*(volatile unsigned long *)(IO_BASE+0x05000050))
#define IO_LCDINTPND		(*(volatile unsigned long *)(IO_BASE+0x05000054))
#define IO_LCDSRCPND		(*(volatile unsigned long *)(IO_BASE+0x05000058))
#define IO_LCDINTMSK		(*(volatile unsigned long *)(IO_BASE+0x0500005c))
#define IO_TCONSEL		(*(volatile unsigned long *)(IO_BASE+0x05000060))

/* NAND Flash */
#define IO_NFCONF		(*(volatile unsigned long *)(IO_BASE+0x06000000))
#define IO_NFCONT		(*(volatile unsigned long *)(IO_BASE+0x06000004))
#define IO_NFCMD		(*(volatile unsigned long *)(IO_BASE+0x06000008))
#define IO_NFADDR		(*(volatile unsigned long *)(IO_BASE+0x0600000c))
#define IO_NFDATA		(*(volatile unsigned long *)(IO_BASE+0x06000010))
#define IO_NFMECC0		(*(volatile unsigned long *)(IO_BASE+0x06000014))
#define IO_NFMECC1		(*(volatile unsigned long *)(IO_BASE+0x06000018))
#define IO_NFSECC		(*(volatile unsigned long *)(IO_BASE+0x0600001c))
#define IO_NFSTAT		(*(volatile unsigned long *)(IO_BASE+0x06000020))
#define IO_NFESTAT0		(*(volatile unsigned long *)(IO_BASE+0x06000024))
#define IO_NFESTAT1		(*(volatile unsigned long *)(IO_BASE+0x06000028))
#define IO_NFMECC0S		(*(volatile unsigned long *)(IO_BASE+0x0600002c))
#define IO_NFMECC1S		(*(volatile unsigned long *)(IO_BASE+0x06000030))
#define IO_NFSECCS		(*(volatile unsigned long *)(IO_BASE+0x06000034))
#define IO_NFSBLK		(*(volatile unsigned long *)(IO_BASE+0x06000038))
#define IO_NFEBLK		(*(volatile unsigned long *)(IO_BASE+0x0600003c))

/* Camera Interface */
#define IO_CISRCFMT		(*(volatile unsigned long *)(IO_BASE+0x07000000))
#define IO_CIWDOFST		(*(volatile unsigned long *)(IO_BASE+0x07000004))
#define IO_CIGCTRL		(*(volatile unsigned long *)(IO_BASE+0x07000008))
#define IO_CICOYSA1		(*(volatile unsigned long *)(IO_BASE+0x07000018))
#define IO_CICOYSA2		(*(volatile unsigned long *)(IO_BASE+0x0700001c))
#define IO_CICOYSA3		(*(volatile unsigned long *)(IO_BASE+0x07000020))
#define IO_CICOYSA4		(*(volatile unsigned long *)(IO_BASE+0x07000024))
#define IO_CICOCBSA1		(*(volatile unsigned long *)(IO_BASE+0x07000028))
#define IO_CICOCBSA2		(*(volatile unsigned long *)(IO_BASE+0x0700002c))
#define IO_CICOCBSA3		(*(volatile unsigned long *)(IO_BASE+0x07000030))
#define IO_CICOCBSA4		(*(volatile unsigned long *)(IO_BASE+0x07000034))
#define IO_CICOCRSA1		(*(volatile unsigned long *)(IO_BASE+0x07000038))
#define IO_CICOCRSA2		(*(volatile unsigned long *)(IO_BASE+0x0700003c))
#define IO_CICOCRSA3		(*(volatile unsigned long *)(IO_BASE+0x07000040))
#define IO_CICOCRSA4		(*(volatile unsigned long *)(IO_BASE+0x07000044))
#define IO_CICOTRGFMT		(*(volatile unsigned long *)(IO_BASE+0x07000048))
#define IO_CICOCTRL		(*(volatile unsigned long *)(IO_BASE+0x0700004c))
#define IO_CICOSCPRERATIO	(*(volatile unsigned long *)(IO_BASE+0x07000050))
#define IO_CICOSCPREDST		(*(volatile unsigned long *)(IO_BASE+0x07000054))
#define IO_CICOSCCTRL		(*(volatile unsigned long *)(IO_BASE+0x07000058))
#define IO_CICOTAREA		(*(volatile unsigned long *)(IO_BASE+0x0700005c))
#define IO_CICOSTATUS		(*(volatile unsigned long *)(IO_BASE+0x07000064))
#define IO_CIPRCLRSA1		(*(volatile unsigned long *)(IO_BASE+0x0700006c))
#define IO_CIPRCLRSA2		(*(volatile unsigned long *)(IO_BASE+0x07000070))
#define IO_CIPRCLRSA3		(*(volatile unsigned long *)(IO_BASE+0x07000074))
#define IO_CIPRCLRSA4		(*(volatile unsigned long *)(IO_BASE+0x07000078))
#define IO_CIPRTRGFMT		(*(volatile unsigned long *)(IO_BASE+0x0700007c))
#define IO_CIPRCTRL		(*(volatile unsigned long *)(IO_BASE+0x07000080))
#define IO_CIPRSCPRERATIO	(*(volatile unsigned long *)(IO_BASE+0x07000084))
#define IO_CIPRSCPREDST		(*(volatile unsigned long *)(IO_BASE+0x07000088))
#define IO_CIPRSCCTRL		(*(volatile unsigned long *)(IO_BASE+0x0700008c))
#define IO_CIPRTAREA		(*(volatile unsigned long *)(IO_BASE+0x07000090))
#define IO_CIPRSTATUS		(*(volatile unsigned long *)(IO_BASE+0x07000098))
#define IO_CIIMGCPT		(*(volatile unsigned long *)(IO_BASE+0x070000a0))

/* UART */
#define IO_ULCON0		(*(volatile unsigned long *)(IO_BASE+0x08000000))
#define IO_UCON0		(*(volatile unsigned long *)(IO_BASE+0x08000004))
#define IO_UFCON0		(*(volatile unsigned long *)(IO_BASE+0x08000008))
#define IO_UMCON0		(*(volatile unsigned long *)(IO_BASE+0x0800000c))
#define IO_UTRSTAT0		(*(volatile unsigned long *)(IO_BASE+0x08000010))
#define IO_UERSTAT0		(*(volatile unsigned long *)(IO_BASE+0x08000014))
#define IO_UFSTAT0		(*(volatile unsigned long *)(IO_BASE+0x08000018))
#define IO_UMSTAT0		(*(volatile unsigned long *)(IO_BASE+0x0800001c))
#define IO_UTXH0		(*(volatile unsigned char *)(IO_BASE+0x08000020))
#define IO_URXH0		(*(volatile unsigned char *)(IO_BASE+0x08000024))
#define IO_UBRDIV0		(*(volatile unsigned long *)(IO_BASE+0x08000028))

#define IO_ULCON1		(*(volatile unsigned long *)(IO_BASE+0x08004000))
#define IO_UCON1		(*(volatile unsigned long *)(IO_BASE+0x08004004))
#define IO_UFCON1		(*(volatile unsigned long *)(IO_BASE+0x08004008))
#define IO_UMCON1		(*(volatile unsigned long *)(IO_BASE+0x0800400c))
#define IO_UTRSTAT1		(*(volatile unsigned long *)(IO_BASE+0x08004010))
#define IO_UERSTAT1		(*(volatile unsigned long *)(IO_BASE+0x08004014))
#define IO_UFSTAT1		(*(volatile unsigned long *)(IO_BASE+0x08004018))
#define IO_UMSTAT1		(*(volatile unsigned long *)(IO_BASE+0x0800401c))
#define IO_UTXH1		(*(volatile unsigned char *)(IO_BASE+0x08004020))
#define IO_URXH1		(*(volatile unsigned char *)(IO_BASE+0x08004024))
#define IO_UBRDIV1		(*(volatile unsigned long *)(IO_BASE+0x08004028))

#define IO_ULCON2		(*(volatile unsigned long *)(IO_BASE+0x08008000))
#define IO_UCON2		(*(volatile unsigned long *)(IO_BASE+0x08008004))
#define IO_UFCON2		(*(volatile unsigned long *)(IO_BASE+0x08008008))
#define IO_UTRSTAT2		(*(volatile unsigned long *)(IO_BASE+0x08008010))
#define IO_UERSTAT2		(*(volatile unsigned long *)(IO_BASE+0x08008014))
#define IO_UFSTAT2		(*(volatile unsigned long *)(IO_BASE+0x08008018))
#define IO_UTXH2		(*(volatile unsigned char *)(IO_BASE+0x08008020))
#define IO_URXH2		(*(volatile unsigned char *)(IO_BASE+0x08008024))
#define IO_UBRDIV2		(*(volatile unsigned long *)(IO_BASE+0x08008028))

/* PWM Timer */
#define IO_TCFG0		(*(volatile unsigned long *)(IO_BASE+0x09000000))
#define IO_TCFG1		(*(volatile unsigned long *)(IO_BASE+0x09000004))
#define IO_TCON			(*(volatile unsigned long *)(IO_BASE+0x09000008))
#define IO_TCNTB0		(*(volatile unsigned long *)(IO_BASE+0x0900000c))
#define IO_TCMPB0		(*(volatile unsigned long *)(IO_BASE+0x09000010))
#define IO_TCNTO0		(*(volatile unsigned long *)(IO_BASE+0x09000014))
#define IO_TCNTB1		(*(volatile unsigned long *)(IO_BASE+0x09000018))
#define IO_TCMPB1		(*(volatile unsigned long *)(IO_BASE+0x0900001c))
#define IO_TCNTO1		(*(volatile unsigned long *)(IO_BASE+0x09000020))
#define IO_TCNTB2		(*(volatile unsigned long *)(IO_BASE+0x09000024))
#define IO_TCMPB2		(*(volatile unsigned long *)(IO_BASE+0x09000028))
#define IO_TCNTO2		(*(volatile unsigned long *)(IO_BASE+0x0900002c))
#define IO_TCNTB3		(*(volatile unsigned long *)(IO_BASE+0x09000030))
#define IO_TCMPB3		(*(volatile unsigned long *)(IO_BASE+0x09000034))
#define IO_TCNTO3		(*(volatile unsigned long *)(IO_BASE+0x09000038))
#define IO_TCNTB4		(*(volatile unsigned long *)(IO_BASE+0x0900003c))
#define IO_TCNTO4		(*(volatile unsigned long *)(IO_BASE+0x09000040))

/* USB Device */
#define IO_FUNC_ADDR_REG	(*(volatile unsigned char *)(IO_BASE+0x0a000140))
#define IO_PWR_REG		(*(volatile unsigned char *)(IO_BASE+0x0a000144))
#define IO_EP_INT_REG		(*(volatile unsigned char *)(IO_BASE+0x0a000148))
#define IO_USB_INT_REG		(*(volatile unsigned char *)(IO_BASE+0x0a000158))
#define IO_EP_INT_EN_REG	(*(volatile unsigned char *)(IO_BASE+0x0a00015c))
#define IO_USB_INT_EN_REG	(*(volatile unsigned char *)(IO_BASE+0x0a00016c))
#define IO_FRAME_NUM1_REG	(*(volatile unsigned char *)(IO_BASE+0x0a000170))
#define IO_FRAME_NUM2_REG	(*(volatile unsigned char *)(IO_BASE+0x0a000174))
#define IO_INDEX_REG		(*(volatile unsigned char *)(IO_BASE+0x0a000178))
#define IO_EP0_CSR		(*(volatile unsigned char *)(IO_BASE+0x0a000184))
#define IO_IN_CSR1_REG		(*(volatile unsigned char *)(IO_BASE+0x0a000184))
#define IO_IN_CSR2_REG		(*(volatile unsigned char *)(IO_BASE+0x0a000188))
#define IO_MAXP_REG		(*(volatile unsigned char *)(IO_BASE+0x0a000180))
#define IO_OUT_CSR1_REG		(*(volatile unsigned char *)(IO_BASE+0x0a000190))
#define IO_OUT_CSR2_REG		(*(volatile unsigned char *)(IO_BASE+0x0a000194))
#define IO_OUT_FIFO_CNT1_REG	(*(volatile unsigned char *)(IO_BASE+0x0a000198))
#define IO_OUT_FIFO_CNT2_REG	(*(volatile unsigned char *)(IO_BASE+0x0a00019c))
#define IO_EP0_FIFO		(*(volatile unsigned char *)(IO_BASE+0x0a0001c0))
#define IO_EP1_FIFO		(*(volatile unsigned char *)(IO_BASE+0x0a0001c4))
#define IO_EP2_FIFO		(*(volatile unsigned char *)(IO_BASE+0x0a0001c8))
#define IO_EP3_FIFO		(*(volatile unsigned char *)(IO_BASE+0x0a0001cc))
#define IO_EP4_FIFO		(*(volatile unsigned char *)(IO_BASE+0x0a0001d0))
#define IO_EP1_DMA_CON		(*(volatile unsigned char *)(IO_BASE+0x0a000200))
#define IO_EP1_DMA_UNIT		(*(volatile unsigned char *)(IO_BASE+0x0a000204))
#define IO_EP1_DMA_FIFO		(*(volatile unsigned char *)(IO_BASE+0x0a000208))
#define IO_EP1_DMA_TTC_L	(*(volatile unsigned char *)(IO_BASE+0x0a00020c))
#define IO_EP1_DMA_TTC_M	(*(volatile unsigned char *)(IO_BASE+0x0a000210))
#define IO_EP1_DMA_TTC_H	(*(volatile unsigned char *)(IO_BASE+0x0a000214))
#define IO_EP2_DMA_CON		(*(volatile unsigned char *)(IO_BASE+0x0a000218))
#define IO_EP2_DMA_UNIT		(*(volatile unsigned char *)(IO_BASE+0x0a00021c))
#define IO_EP2_DMA_FIFO		(*(volatile unsigned char *)(IO_BASE+0x0a000220))
#define IO_EP2_DMA_TTC_L	(*(volatile unsigned char *)(IO_BASE+0x0a000224))
#define IO_EP2_DMA_TTC_M	(*(volatile unsigned char *)(IO_BASE+0x0a000228))
#define IO_EP2_DMA_TTC_H	(*(volatile unsigned char *)(IO_BASE+0x0a00022c))
#define IO_EP3_DMA_CON		(*(volatile unsigned char *)(IO_BASE+0x0a000240))
#define IO_EP3_DMA_UNIT		(*(volatile unsigned char *)(IO_BASE+0x0a000244))
#define IO_EP3_DMA_FIFO		(*(volatile unsigned char *)(IO_BASE+0x0a000248))
#define IO_EP3_DMA_TTC_L	(*(volatile unsigned char *)(IO_BASE+0x0a00024c))
#define IO_EP3_DMA_TTC_M	(*(volatile unsigned char *)(IO_BASE+0x0a000250))
#define IO_EP3_DMA_TTC_H	(*(volatile unsigned char *)(IO_BASE+0x0a000254))
#define IO_EP4_DMA_CON		(*(volatile unsigned char *)(IO_BASE+0x0a000258))
#define IO_EP4_DMA_UNIT		(*(volatile unsigned char *)(IO_BASE+0x0a00025c))
#define IO_EP4_DMA_FIFO		(*(volatile unsigned char *)(IO_BASE+0x0a000260))
#define IO_EP4_DMA_TTC_L	(*(volatile unsigned char *)(IO_BASE+0x0a000264))
#define IO_EP4_DMA_TTC_M	(*(volatile unsigned char *)(IO_BASE+0x0a000268))
#define IO_EP4_DMA_TTC_H	(*(volatile unsigned char *)(IO_BASE+0x0a00026c))

/* Watchdog Timer */
#define IO_WTCON		(*(volatile unsigned long *)(IO_BASE+0x0b000000))
#define IO_WTDAT		(*(volatile unsigned long *)(IO_BASE+0x0b000004))
#define IO_WTCNT		(*(volatile unsigned long *)(IO_BASE+0x0b000008))

/* IIC */
#define IO_IICCON		(*(volatile unsigned long *)(IO_BASE+0x0c000000))
#define IO_IICSTAT		(*(volatile unsigned long *)(IO_BASE+0x0c000004))
#define IO_IICADD		(*(volatile unsigned long *)(IO_BASE+0x0c000008))
#define IO_IICDS		(*(volatile unsigned long *)(IO_BASE+0x0c00000c))
#define IO_IICLC		(*(volatile unsigned long *)(IO_BASE+0x0c000010))

/* IIS */
#define IO_IISCON		(*(volatile unsigned long *)(IO_BASE+0x0d000000))
#define IO_IISMOD		(*(volatile unsigned long *)(IO_BASE+0x0d000004))
#define IO_IISPSR		(*(volatile unsigned long *)(IO_BASE+0x0d000008))
#define IO_IISFCON		(*(volatile unsigned long *)(IO_BASE+0x0d00000c))
#define IO_IISFIFO		(*(volatile unsigned long *)(IO_BASE+0x0d000010))

/* I/O port */
#define IO_GPACON		(*(volatile unsigned long *)(IO_BASE+0x0e000000))
#define IO_GPADAT		(*(volatile unsigned long *)(IO_BASE+0x0e000004))
#define IO_GPBCON		(*(volatile unsigned long *)(IO_BASE+0x0e000010))
#define IO_GPBDAT		(*(volatile unsigned long *)(IO_BASE+0x0e000014))
#define IO_GPBUP		(*(volatile unsigned long *)(IO_BASE+0x0e000018))
#define IO_GPCCON		(*(volatile unsigned long *)(IO_BASE+0x0e000020))
#define IO_GPCDAT		(*(volatile unsigned long *)(IO_BASE+0x0e000024))
#define IO_GPCUP		(*(volatile unsigned long *)(IO_BASE+0x0e000028))
#define IO_GPDCON		(*(volatile unsigned long *)(IO_BASE+0x0e000030))
#define IO_GPDDAT		(*(volatile unsigned long *)(IO_BASE+0x0e000034))
#define IO_GPDUP		(*(volatile unsigned long *)(IO_BASE+0x0e000038))
#define IO_GPECON		(*(volatile unsigned long *)(IO_BASE+0x0e000040))
#define IO_GPEDAT		(*(volatile unsigned long *)(IO_BASE+0x0e000044))
#define IO_GPEUP		(*(volatile unsigned long *)(IO_BASE+0x0e000048))
#define IO_GPFCON		(*(volatile unsigned long *)(IO_BASE+0x0e000050))
#define IO_GPFDAT		(*(volatile unsigned long *)(IO_BASE+0x0e000054))
#define IO_GPFUP		(*(volatile unsigned long *)(IO_BASE+0x0e000058))
#define IO_GPGCON		(*(volatile unsigned long *)(IO_BASE+0x0e000060))
#define IO_GPGDAT		(*(volatile unsigned long *)(IO_BASE+0x0e000064))
#define IO_GPGUP		(*(volatile unsigned long *)(IO_BASE+0x0e000068))
#define IO_GPHCON		(*(volatile unsigned long *)(IO_BASE+0x0e000070))
#define IO_GPHDAT		(*(volatile unsigned long *)(IO_BASE+0x0e000074))
#define IO_GPHUP		(*(volatile unsigned long *)(IO_BASE+0x0e000078))
#define IO_GPJCON		(*(volatile unsigned long *)(IO_BASE+0x0e0000d0))
#define IO_GPJDAT		(*(volatile unsigned long *)(IO_BASE+0x0e0000d4))
#define IO_GPJUP		(*(volatile unsigned long *)(IO_BASE+0x0e0000d8))
#define IO_MISCCR		(*(volatile unsigned long *)(IO_BASE+0x0e000080))
#define IO_DCLKCON		(*(volatile unsigned long *)(IO_BASE+0x0e000084))
#define IO_EXTINT0		(*(volatile unsigned long *)(IO_BASE+0x0e000088))
#define IO_EXTINT1		(*(volatile unsigned long *)(IO_BASE+0x0e00008c))
#define IO_EXTINT2		(*(volatile unsigned long *)(IO_BASE+0x0e000090))
#define IO_EINTFLT0		(*(volatile unsigned long *)(IO_BASE+0x0e000094))
#define IO_EINTFLT1		(*(volatile unsigned long *)(IO_BASE+0x0e000098))
#define IO_EINTFLT2		(*(volatile unsigned long *)(IO_BASE+0x0e00009c))
#define IO_EINTFLT3		(*(volatile unsigned long *)(IO_BASE+0x0e0000a0))
#define IO_EINTMASK		(*(volatile unsigned long *)(IO_BASE+0x0e0000a4))
#define IO_EINTPEND		(*(volatile unsigned long *)(IO_BASE+0x0e0000a8))
#define IO_GSTATUS0		(*(volatile unsigned long *)(IO_BASE+0x0e0000ac))
#define IO_GSTATUS1		(*(volatile unsigned long *)(IO_BASE+0x0e0000b0))
#define IO_GSTATUS2		(*(volatile unsigned long *)(IO_BASE+0x0e0000b4))
#define IO_GSTATUS3		(*(volatile unsigned long *)(IO_BASE+0x0e0000b8))
#define IO_GSTATUS4		(*(volatile unsigned long *)(IO_BASE+0x0e0000bc))
#define IO_DSC0			(*(volatile unsigned long *)(IO_BASE+0x0e0000c4))
#define IO_DSC1			(*(volatile unsigned long *)(IO_BASE+0x0e0000c8))
#define IO_MSLCON		(*(volatile unsigned long *)(IO_BASE+0x0e0000cc))

/* RTC */
#define IO_RTCCON		(*(volatile unsigned char *)(IO_BASE+0x0f000040))
#define IO_TICNT		(*(volatile unsigned char *)(IO_BASE+0x0f000044))
#define IO_RTCALM		(*(volatile unsigned char *)(IO_BASE+0x0f000050))
#define IO_ALMSEC		(*(volatile unsigned char *)(IO_BASE+0x0f000054))
#define IO_ALMMIN		(*(volatile unsigned char *)(IO_BASE+0x0f000058))
#define IO_ALMHOUR		(*(volatile unsigned char *)(IO_BASE+0x0f00005c))
#define IO_ALMDATE		(*(volatile unsigned char *)(IO_BASE+0x0f000060))
#define IO_ALMMON		(*(volatile unsigned char *)(IO_BASE+0x0f000064))
#define IO_ALMYEAR		(*(volatile unsigned char *)(IO_BASE+0x0f000068))
#define IO_BCDSEC		(*(volatile unsigned char *)(IO_BASE+0x0f000070))
#define IO_BCDMIN		(*(volatile unsigned char *)(IO_BASE+0x0f000074))
#define IO_BCDHOUR		(*(volatile unsigned char *)(IO_BASE+0x0f000078))
#define IO_BCDDATE		(*(volatile unsigned char *)(IO_BASE+0x0f00007c))
#define IO_BCDDAY		(*(volatile unsigned char *)(IO_BASE+0x0f000080))
#define IO_BCDMON		(*(volatile unsigned char *)(IO_BASE+0x0f000084))
#define IO_BCDYEAR		(*(volatile unsigned char *)(IO_BASE+0x0f000088))

/* A/D converter */
#define IO_ADCCON		(*(volatile unsigned long *)(IO_BASE+0x10000000))
#define IO_ADCTSC		(*(volatile unsigned long *)(IO_BASE+0x10000004))
#define IO_ADCDLY		(*(volatile unsigned long *)(IO_BASE+0x10000008))
#define IO_ADCDAT0		(*(volatile unsigned long *)(IO_BASE+0x1000000c))
#define IO_ADCDAT1		(*(volatile unsigned long *)(IO_BASE+0x10000010))
#define IO_ADCUPDN		(*(volatile unsigned long *)(IO_BASE+0x10000014))

/* SPI */
#define IO_SPCON0		(*(volatile unsigned long *)(IO_BASE+0x11000000))
#define IO_SPSTA0		(*(volatile unsigned long *)(IO_BASE+0x11000004))
#define IO_SPPIN0		(*(volatile unsigned long *)(IO_BASE+0x11000008))
#define IO_SPPRE0		(*(volatile unsigned long *)(IO_BASE+0x1100000c))
#define IO_SPTDAT0		(*(volatile unsigned long *)(IO_BASE+0x11000010))
#define IO_SPRDAT0		(*(volatile unsigned long *)(IO_BASE+0x11000014))
#define IO_SPCON1		(*(volatile unsigned long *)(IO_BASE+0x11000020))
#define IO_SPSTA1		(*(volatile unsigned long *)(IO_BASE+0x11000024))
#define IO_SPPIN1		(*(volatile unsigned long *)(IO_BASE+0x11000028))
#define IO_SPPRE1		(*(volatile unsigned long *)(IO_BASE+0x1100002c))
#define IO_SPTDAT1		(*(volatile unsigned long *)(IO_BASE+0x11000030))
#define IO_SPRDAT1		(*(volatile unsigned long *)(IO_BASE+0x11000034))

/* SD interface */
#define IO_SDICON		(*(volatile unsigned long *)(IO_BASE+0x12000000))
#define IO_SDIPRE		(*(volatile unsigned long *)(IO_BASE+0x12000004))
#define IO_SDICARG		(*(volatile unsigned long *)(IO_BASE+0x12000008))
#define IO_SDICCON		(*(volatile unsigned long *)(IO_BASE+0x1200000c))
#define IO_SDICSTA		(*(volatile unsigned long *)(IO_BASE+0x12000010))
#define IO_SDIRSP0		(*(volatile unsigned long *)(IO_BASE+0x12000014))
#define IO_SDIRSP1		(*(volatile unsigned long *)(IO_BASE+0x12000018))
#define IO_SDIRSP2		(*(volatile unsigned long *)(IO_BASE+0x1200001c))
#define IO_SDIRSP3		(*(volatile unsigned long *)(IO_BASE+0x12000020))
#define IO_SDIDTIMER		(*(volatile unsigned long *)(IO_BASE+0x12000024))
#define IO_SDIBSIZE		(*(volatile unsigned long *)(IO_BASE+0x12000028))
#define IO_SDIDCON		(*(volatile unsigned long *)(IO_BASE+0x1200002c))
#define IO_SDIDCNT		(*(volatile unsigned long *)(IO_BASE+0x12000030))
#define IO_SDIDTA		(*(volatile unsigned long *)(IO_BASE+0x12000034))
#define IO_SDIFSTA		(*(volatile unsigned long *)(IO_BASE+0x12000038))
#define IO_SDIIMSK		(*(volatile unsigned long *)(IO_BASE+0x1200003c))
#define IO_SDIDAT		(*(volatile unsigned char *)(IO_BASE+0x12000040))

/* AC97 Audio-CODEC Interface */
#define IO_AC_GLBCTRL		(*(volatile unsigned char *)(IO_BASE+0x13000000))
#define IO_AC_GLBSTAT		(*(volatile unsigned char *)(IO_BASE+0x13000004))
#define IO_AC_CODEC_CMD		(*(volatile unsigned char *)(IO_BASE+0x13000008))
#define IO_AC_CODEC_STAT	(*(volatile unsigned char *)(IO_BASE+0x1300000c))
#define IO_AC_PCMADDR		(*(volatile unsigned char *)(IO_BASE+0x13000010))
#define IO_AC_MICADDR		(*(volatile unsigned char *)(IO_BASE+0x13000014))
#define IO_AC_PCMDATA		(*(volatile unsigned char *)(IO_BASE+0x13000018))
#define IO_AC_MICDATA		(*(volatile unsigned char *)(IO_BASE+0x1300001c))

/* Clock Control Register (CLKCON) bits definitions */
#define	CLKCON_AC97		(1<<20)
#define	CLKCON_CAMERA		(1<<19)
#define	CLKCON_SPI		(1<<18)
#define	CLKCON_IIS		(1<<17)
#define	CLKCON_IIC		(1<<16)
#define	CLKCON_ADC		(1<<15)
#define	CLKCON_RTC		(1<<14)
#define	CLKCON_GPIO		(1<<13)
#define	CLKCON_UART2		(1<<12)
#define	CLKCON_UART1		(1<<11)
#define	CLKCON_UART0		(1<<10)
#define	CLKCON_SDI		(1<<9)
#define	CLKCON_PWMTIMER		(1<<8)
#define	CLKCON_USB_DEVICE	(1<<7)
#define	CLKCON_USB_HOST		(1<<6)
#define	CLKCON_LCDC		(1<<5)
#define	CLKCON_NAND		(1<<4)
#define	CLKCON_SLEEP		(1<<3)
#define	CLKCON_IDLE		(1<<2)

#endif / * __ASM_ARCH_S3C2440_H */
