/*
 * linux/include/asm-arm/arch-s3c2440/irqs.h
 */
#ifndef __ASM_ARCH_IRQS_H
#define __ASM_ARCH_IRQS_H

#define NR_IRQS		32

#define	IRQ_EINT0	0	/* External interrupt 0				*/
#define	IRQ_EINT1	1	/* External interrupt 1				*/
#define	IRQ_EINT2	2	/* Externel interrupt 2				*/
#define	IRQ_EINT3	3	/* External interrupt 3				*/
#define	IRQ_EINT4_7	4	/* External interrupt 4 -7			*/
#define	IRQ_EINT8_23	5	/* External interrupt 8 - 23			*/
#define	IRQ_CAM		6	/* Camera Interface (INT_CAM_C, INT_CAM_P)	*/
#define	IRQ_BATT_FLT	7	/* Battery Fault interrupt			*/
#define	IRQ_TICK	8	/* RTC Time tick interrupt			*/
#define	IRQ_WDT_AC97	9	/* Watch-Dog timer interrupt(INT_WDT, INT_AC97)	*/
#define	IRQ_TIMER0	10	/* Timer0 interrupt				*/
#define	IRQ_TIMER1	11	/* Timer1 interrupt				*/
#define	IRQ_TIMER2	12	/* Timer2 interrupt				*/
#define	IRQ_TIMER3	13	/* Timer3 interrupt				*/
#define	IRQ_TIMER4	14	/* Timer4 interrupt				*/
#define	IRQ_UART2	15	/* UART2 interrupt (ERR, RXD and TXD)		*/
#define	IRQ_LCD		16	/* LCD interrupt (INT_FrSyn and INT_FiCnt)	*/
#define	IRQ_DMA0	17	/* DMA channel 0 interrupt			*/
#define	IRQ_DMA1	18	/* DMA channel 1 intgerupt			*/
#define	IRQ_DMA2	19	/* DMA channel 2 interrupt			*/
#define	IRQ_DMA3	20	/* DMA channel 3 interrupt			*/
#define	IRQ_SDI		21	/* SDI interrupt				*/
#define	IRQ_SPI0	22	/* SPI0 interrupt				*/
#define	IRQ_UART1	23	/* UART1 interrupt (ERR, RXD and TXD)		*/
#define	IRQ_NFCON	24	/* NAND Flash Control interupt			*/
#define	IRQ_USBD	25	/* USB Device interrupt				*/
#define	IRQ_USBH	26	/* USB Host interrupt				*/
#define	IRQ_IIC		27	/* IIC interrupt				*/
#define	IRQ_UART0	28	/* UART0 interrupt (ERR, RXD and TXD)		*/
#define	IRQ_SPI1	29	/* SPI1 interrupt				*/
#define	IRQ_RTC		30	/* RTC alarm interrupt				*/
#define	IRQ_ADC		31	/* ADC EOC and Touch interrupt(INT_ADC_S/INT_TC */

/* Sub sources bit position on SUBSRCPND and INTSUBMSK */
#define	INT_RXD0	1
#define	INT_TXD0	(1<<1)
#define	INT_ERR0	(1<<2)
#define	INT_RXD1	(1<<3)
#define	INT_TXD1	(1<<4)
#define	INT_ERR1	(1<<5)
#define	INT_RXD2	(1<<6)
#define	INT_TXD2	(1<<7)
#define	INT_ERR2	(1<<8)
#define	INT_TC		(1<<9)
#define	INT_ADC_S	(1<<10)
#define	INT_CAM_C	(1<<11)
#define	INT_CAM_P	(1<<12)
#define	INT_WDT		(1<<13)
#define	INT_AC97	(1<<14)

#endif /* __ASM_ARCH_IRQS_H */
