/*
 * linux/include/asm-arm/arch-s3c2440/io.h
 */
#ifndef __ASM_ARM_ARCH_IO_H
#define __ASM_ARM_ARCH_IO_H

#define	IO_SPACE_LIMIT	0xffffffff

#define inb(p)		(*(volatile unsigned char  *)(p))
#define inw(p)		(*(volatile unsigned short *)(p))
#define inl(p)		(*(volatile unsigned long  *)(p))
#define outb(v,p)	(*(volatile unsigned char  *)(p) = (v))
#define outw(v,p)	(*(volatile unsigned short *)(p) = (v))
#define outl(v,p)	(*(volatile unsigned long  *)(p) = (v))

#define readb(p)	(*(volatile unsigned char  *)(p))
#define readw(p)	(*(volatile unsigned short *)(p))
#define readl(p)	(*(volatile unsigned long  *)(p))
#define writeb(v,p)	(*(volatile unsigned char  *)(p) = (v))
#define writew(v,p)	(*(volatile unsigned short *)(p) = (v))
#define writel(v,p)	(*(volatile unsigned long  *)(p) = (v))

#define insb(port, to, len)	__raw_readsb(port, to, len)
#define	insw(port, to, len)	__raw_readsw(port, to, len)
#define	insl(port, to, len)	__raw_readsl(port, to, len)
#define	outsb(port, from, len)	__raw_writesb(port, from, len)
#define	outsw(port, from, len)	__raw_writesw(port, from, len)
#define	outsl(port, from, len)	__raw_writesl(port, from, len)

#endif
