/*
 * linux/include/asm-arm/arch-s3c2440/ide.h
 */
#ifndef __ASM_ARCH_IDE_H
#define __ASM_ARCH_IDE_H

#include <linux/delay.h>
#include <asm/irq.h>
#include <asm/arch/hardware.h>

#define	ATA_CMD_BASE		IOCS3_BASE
#define	ATA_CTL_BASE		IOCS4_BASE
#define	ATA_IRQ			IRQ_EINT2
#define	ATA_STATUS_REG		(*((volatile unsigned char *)(ATA_CMD_BASE+0x0e)))

/* Initialize GPIO direction and output state (HDD and USB2.0) */
static __inline__ void ide_init_default_hwifs(void)
{
	hw_regs_t hw;

	IO_EXTINT0  = (IO_EXTINT0 & 0xfffff0ff) | 0x00000400; // EINT2 set to rising edge triggered

	memset(&hw, 0, sizeof(hw));
	hw.io_ports[0] = ATA_CMD_BASE;
	hw.io_ports[1] = ATA_CMD_BASE+2;
	hw.io_ports[2] = ATA_CMD_BASE+4;
	hw.io_ports[3] = ATA_CMD_BASE+6;
	hw.io_ports[4] = ATA_CMD_BASE+8;
	hw.io_ports[5] = ATA_CMD_BASE+10;
	hw.io_ports[6] = ATA_CMD_BASE+12;
	hw.io_ports[7] = ATA_CMD_BASE+14;
	hw.io_ports[8] = ATA_CTL_BASE+0x1c;
	hw.irq = ATA_IRQ;
	ide_register_hw(&hw, NULL);
}

static __inline__ void ide_init_hwif_ports(hw_regs_t *hw, int data_port, int ctrl_port, int *irq)
{
	hw->io_ports[0] = data_port;
	if ((unsigned long)ctrl_port - (unsigned long)data_port == 14L) {
		hw->io_ports[1] = data_port+1;
		hw->io_ports[2] = data_port+2;
		hw->io_ports[3] = data_port+3;
		hw->io_ports[4] = data_port+4;
		hw->io_ports[5] = data_port+5;
		hw->io_ports[6] = data_port+6;
		hw->io_ports[7] = data_port+7;
	} else {
		hw->io_ports[1] = data_port+2;
		hw->io_ports[2] = data_port+4;
		hw->io_ports[3] = data_port+6;
		hw->io_ports[4] = data_port+8;
		hw->io_ports[5] = data_port+10;
		hw->io_ports[6] = data_port+12;
		hw->io_ports[7] = data_port+14;
	}
	hw->io_ports[8] = ctrl_port;
	hw->irq = *irq;
}

#endif /* __ASM_ARCH_IDE_H */
