/*
 * linux/arch/arm/mach-s3c2440/core.c
 */

#include <linux/config.h>
#include <linux/kernel.h>
#include <linux/tty.h>
#include <linux/init.h>
#include <linux/list.h>
#include <asm/setup.h>
#include <asm/mach-types.h>
#include <asm/proc/domain.h>
#include <asm/mach/arch.h>
#include <asm/mach/map.h>
#include <asm/mach/irq.h>
#include <asm/arch/irqs.h>
#include <asm/arch/hardware.h>

unsigned long initrd_size;

unsigned long sleep_phys_sp(void *sp)
{
	return virt_to_phys(sp);
}

static void s3c2440_mask_irq(unsigned int irq)
{
	IO_INTMSK |= (1 << irq);
}

static void s3c2440_unmask_irq(unsigned int irq)
{
	IO_INTMSK &= ~(1 << irq);
}

static void s3c2440_mask_ack_irq(unsigned int irq)
{
	IO_INTMSK |= (1 << irq);
	IO_SRCPND = (1 << irq);
	IO_INTPND = (1 << irq);
}

__init void s3c2440_init_irq(void)
{
	int irq;

	IO_EINTMASK  = 0x00fffff0;
	IO_EINTPEND  = 0x00fffff0;

	IO_PRIORITY  = 0x00000000;
	IO_INTMSK    = 0xffffffff;
	IO_INTSUBMSK = 0x7fff;
	IO_INTMOD    = 0x00000000;	/* all IRQ mode */
	IO_SRCPND    = 0xffffffff;
	IO_INTPND    = 0xffffffff;
	IO_SUBSRCPND = 0x7fff;

	for (irq = 0; irq < NR_IRQS; irq++) {
		irq_desc[irq].valid	= 1;
		irq_desc[irq].probe_ok	= 1;
		irq_desc[irq].mask_ack	= s3c2440_mask_ack_irq;
		irq_desc[irq].mask	= s3c2440_mask_irq;
		irq_desc[irq].unmask	= s3c2440_unmask_irq;
	}
}

static struct map_desc s3c2440_io_desc[] __initdata = {
	{IO_BASE,    IO_START,    IO_SIZE,    DOMAIN_IO,     0, 1, 0, 0},
	{FLASH_BASE, FLASH_START, FLASH_SIZE, DOMAIN_IO,     0, 1, 0, 0},
	{SRAM_BASE,  SRAM_START,  SRAM_SIZE,  DOMAIN_KERNEL, 0, 1, 0, 0},
	{IOCS2_BASE, IOCS2_START, IOCS2_SIZE, DOMAIN_IO,     0, 1, 0, 0},
	{IOCS3_BASE, IOCS3_START, IOCS3_SIZE, DOMAIN_IO,     0, 1, 0, 0},
	{IOCS4_BASE, IOCS4_START, IOCS4_SIZE, DOMAIN_IO,     0, 1, 0, 0},
	{AUX1_BASE,  AUX1_START,  AUX1_SIZE,  DOMAIN_IO,     0, 1, 0, 0},
	{AUX2_BASE,  AUX2_START,  AUX2_SIZE,  DOMAIN_KERNEL, 0, 1, 1, 0},
	{AUX3_BASE,  AUX3_START,  AUX3_SIZE,  DOMAIN_IO,     0, 1, 1, 1},
	{AUX4_BASE,  AUX4_START,  AUX4_SIZE,  DOMAIN_IO,     0, 1, 0, 0},
	{AUX5_BASE,  AUX5_START,  AUX5_SIZE,  DOMAIN_IO,     0, 1, 1, 0},
	LAST_DESC
};

void __init s3c2440_map_io(void)
{
	iotable_init(s3c2440_io_desc);
}

static void __init fixup_s3c2440(
	struct machine_desc* desc,
	struct param_struct* params,
	char** cmdline,
	struct meminfo* mi)
{
	mi->nr_banks      = 1;
	mi->bank[0].start = PHYS_OFFSET;
	mi->bank[0].size  = (29.5*1024*1024);
	mi->bank[0].node  = 0;

#ifdef CONFIG_BLK_DEV_INITRD
	/* for initrd expreriment */
	ROOT_DEV = MKDEV(RAMDISK_MAJOR, 0);
	setup_ramdisk(1, 0, 0, CONFIG_BLK_DEV_RAM_SIZE);
	printk("initrd_size = 0x%08lx\n", initrd_size);
	setup_initrd(INITRD_BASE, initrd_size);
#endif
}

MACHINE_START(S3C2440, "TOSHIBA/VENETIAN")
	MAINTAINER("TOSHIBA CORPORATION")
	BOOT_MEM(PHYS_OFFSET, IO_START, IO_BASE)
	FIXUP(fixup_s3c2440)
	MAPIO(s3c2440_map_io)
	INITIRQ(s3c2440_init_irq)
MACHINE_END
